require ("scripts/style.lua");

TitleFont = {
	standardFont,
	32,
	Color(0,0,255,255)
};

HeaderFont = {
	standardFont,
	24,
	Color(0,0,255,255)
};


HeaderStyle = {
	parent = DefaultStyle,
	font = HeaderFont,
	w = kMax,
	h = 200,
	flags = kHAlignLeft + kVAlignTop,
};

DescripFont = {
	standardFont,
	18,
	BorderColor
};

MPDescripFont = {
	standardFont,
	22,
	BlackColor
};
	
DescripStyle = {
	parent = DefaultStyle,
	font = DescripFont,
	w = 170,
	h = 200,
	flags = kHAlignLeft + kVAlignTop,
};

MakeDialog
{
	Bitmap
	{
		name="backgroundimage",
		image="backgrounds/fullscreendialog",
		x=0, y=0, w=kMax, h=kMax,
		
		Text
		{
			font = TitleFont,
			x=0,y=30,w=kMax,h=80,
			flags = kHAlignCenter + kVAlignTop,
			label = "mp_howtoplay"
		};
		
		SetStyle(DefaultStyle);
		
		
		Text
		{
			font = MPDescripFont,
			x=50,y=75,w=kMax,h=25,
			flags = kHAlignLeft + kVAlignTop,
			label = "mp_help2_1"
		};
		Text
		{
			font = HeaderFont,
			x=50,y=125,w=300,h=25,
			flags = kHAlignLeft + kVAlignTop,
			label = "mp_help2_2"
		};
		Text
		{
			font = DescripFont,
			x=50,y=160,w=300,h=75,
			flags = kHAlignLeft + kVAlignTop,
			label = "mp_help2_3"
		};
		Text
		{
			font = DescripFont,
			x=50,y=255,w=300,h=45,
			flags = kHAlignLeft + kVAlignTop,
			label = "mp_help2_4"
		};
		Bitmap
		{
			x = 400,
			y = 105,
			image = "multi/help_assignedtables"
		};
		Text
		{
			font = DescripFont,
			x=620,y=260,w=140,h=75,
			flags = kHAlignLeft + kVAlignTop,
			label = "mp_help2_5"
		};
		Bitmap
		{
			x = 620,
			y = 150,
			image = "multi/help_coloredtrays"
		};
		Text
		{
			font = HeaderFont,
			x=50,y=430,w=300,h=25,
			flags = kHAlignLeft + kVAlignTop,
			label = "mp_help2_6"
		};
		Text
		{
			font = DescripFont,
			x=50,y=455,w=300,h=50,
			flags = kHAlignLeft + kVAlignTop,
			label = "mp_help2_7"
		};
		Bitmap
		{
			x = 400,
			y = 340,
			image = "multi/help_openfloor"
		};
		
		SetStyle(SmallestButtonStyle);
		Button
		{
			x=kCenter,
			y=540,
			name="back",
			label="back",
			command=
				function()
					ActivateHelpClock(false);
					PopModal("scripts/multiplayer/help2.lua");
				end
		},
		SetStyle(HelpArrowStyle);
		
		
		Button
		{
			x=700,
			y=530,
					hflip = true,
			name="right",
			command=
				function()
					SwapToModalSetName("scripts/multiplayer/help3.lua");
				end
		},
		
		Button
		{
			x=45,
			y=530,
			name="right",
			command=
				function()
					SwapToModalSetName("scripts/multiplayer/help1.lua");
				end
		},
	},
};

ActivateHelpClock(true);